unit Unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls, ExtCtrls,
  Menus, BaseUnix, TermIO, Linux;

///////////////////////////////////////////////////////////////////////////////////
// remember to add -dUseCThreads to Project -> Project Options -> Custom Options //
///////////////////////////////////////////////////////////////////////////////////

// for use of inotify routines, see:
// https://www.freepascal.org/~michael/articles/dirwatch/dirwatch.pdf

type

  { TForm1 }

  TForm1 = class(TForm)
    Memo1: TMemo;
    Panel1: TPanel;
    PopupMenu1: TPopupMenu;
    Timer1: TTimer;
    procedure FormActivate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private

  public

  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

{ TForm1 }


const CLlength=20;
var ChangeList:array[0..CLlength-1] of record
                                         mask:integer;
                                         name:string
                                       end;
const clHead:integer=0;
      clTail:integer=0;

 type TCheckThread = class(TThread)
     private
     protected
       procedure Execute; override;
     end;

// separate thread used to check for changes in /dev
procedure TCheckThread.Execute;
var fd, wd, bytesread, filenamelength:integer;
     fds : Tfdset;
     buffer:array [0..4096] of byte;
     event : ^inotify_event;
     filename:string;
     p:pchar;
begin
  fd:=inotify_init();
  try
    wd:=inotify_add_watch(fd, '/dev', IN_CREATE or IN_DELETE {or IN_ISDIR or IN_ONLYDIR});
    fpFD_Zero(fds);
    fpFD_SET(fd, fds);

    while (fpSelect(fd+1, @fds, nil, nil, nil)>=0) do
    begin
      bytesread:=fpRead(fd, buffer, sizeof(buffer));
      event:=@buffer;

      While ((pchar(event)-@buffer)<bytesread) do
      begin
        filenamelength:=event^.len;

        if (filenamelength>0) then
        begin
          p:=@event^.name+filenamelength-1;
          While (p^=#0) do
          begin
            dec(p);
            dec(filenamelength)
          end
        end;

        setlength(filename, filenamelength);
        if (filenamelength>0) then move(event^.name,filename[1],filenamelength);
                                   //     source    destination      size

        if pos('tty',filename)=1 then
//      if event^.wd=wd then
        begin
          ChangeList[clHead].mask:=event^.MASK;                // valid port names are saved in a queue
          ChangeList[clHead].name:=filename;                   // ... ready to be picked up by the timer
          clHead:=(clHead+1) mod CLlength;                     // ... that runs every 100ms.
        end;

//      writeln('Change 0x', IntToHex(event^.mask, 8),
//              ' detected for "/dev/', filename, '"');

        ptrint(event):=ptrint(event)+sizeof(inotify_event)+event^.len-1
      end
    end;
  finally
    fpClose(fd)
  end
end;






type
   TSerialStruct = packed record
          typ: cint;
          line: cint;
          port: cuint;
          irq:  cint;
          flags: cint;
          xmit_fifo_size: cint;
          custom_divisor: cint;
          baud_base: cint;
          close_delay: cushort;
          io_type: cchar;
          reserved_char:  pcchar;
          hub6: cint;
          closing_wait: cushort; // time to wait before closing
          closing_wait2: cushort; // no longer used...
          iomem_base: pcchar;
          iomem_reg_shift: cushort;
          port_high: clong; // cookie passed into ioremap
   end;

// method based on information obtained from the following two sites:
// https://www.lazarusforum.de/viewtopic.php?p=72837
// https://stackoverflow.com/questions/2530096
function CheckDevice(DeviceName:string):boolean;               // checks to see if the device named is a live
var DriverName:string;                                         // ... serial port. this is done by checking
            FD:longint;                                        // ... entries in /sys/class/tty including the
            SS:TSerialStruct;                                  // ... presence of a link to a device driver.
            ST:stat;
begin
  Result:=false;

  st.st_mode:=0;
  if (DeviceName<>'.') and (DeviceName<>'..') then
  if FileExists('/sys/class/tty/'+DeviceName+'/device/driver') then
  if fpLstat('/sys/class/tty/'+DeviceName+'/device', ST)=0 then
  if fpS_ISLNK(ST.st_mode) then
  begin
    DriverName:=ExtractFileName(fpReadLink('/sys/class/tty/'+DeviceName+'/device/driver'));

    if DriverName<>'serial8250' then Result:=true
                                else begin
                                       FD:=fpOpen('/dev/'+DeviceName, O_RDWR or O_NONBLOCK or O_NOCTTY);
                                       if FD>0 then
                                       try
                                         if fpIOCtl(FD, TIOCGSERIAL, @SS)<>-1 then
                                         if SS.typ<>0 then Result:=true;
                                         fpclose(FD)
                                       except end
                                     end
  end
end;






procedure TForm1.Timer1Timer(Sender: TObject);                 // 100ms timer that picks up port names from the
var I:integer;                                                 // ... queue, checks that they are live, and if
    S:string;                                                  // ... so adds them into the list held in Memo1.
begin
  while clHead<>clTail do
  begin
    Memo1.Lines.BeginUpdate;
    I:=Memo1.Lines.IndexOf('no serial ports found');
    if I>=0 then Memo1.Lines.Delete(I);
    I:=Memo1.Lines.IndexOf(ChangeList[clTail].name);
    if I>=0 then Memo1.Lines.Delete(I);

    if (ChangeList[clTail].mask and IN_CREATE)>0 then
        if CheckDevice(ChangeList[clTail].name) then
            Memo1.Lines.Add(ChangeList[clTail].name);
    if Memo1.Lines.Count=0 then Memo1.Lines.Add('no serial ports found');

    S:=Memo1.Text;
    if RightStr(S,1)=#10 then S:=copy(S, 1, length(S)-1);      // remove final linefeed from memo
    Memo1.Text:=S;                                             // (stops the caret going beyond the last line)

    Memo1.Lines.EndUpdate;
    Memo1.SelLength:=0;
    Memo1.SelStart:=Length(Memo1.Text);

    clTail:=(clTail+1) mod CLlength
  end
end;






procedure TForm1.FormActivate(Sender: TObject);                // one-time startup code, including a full
const initial:boolean=true;                                    // ... scan of /sys/class/tty and check of
var SR:TSearchRec;                                             // ... every current entry to create an
     S:string;                                                 // ... initial list of live serial ports.
begin
  if initial then
  begin
    initial:=false;
    Memo1.Clear;

    if FindFirst('/sys/class/tty/*', faDirectory , SR) = 0 then
    repeat
      if CheckDevice(SR.Name) then Memo1.Lines.Add(SR.Name)
    until FindNext(SR) <> 0;
    FindClose(SR);

    if Memo1.Lines.Count=0 then Memo1.Lines.Add('no serial ports found');

    S:=Memo1.Text;
    if RightStr(S,1)=#10 then S:=copy(S, 1, length(S)-1);      // remove final linefeed from memo
    Memo1.Text:=S;                                             // (stops the caret going beyond the last line)

    Memo1.SelLength := 0;
    Memo1.SelStart := Length(Memo1.Text);

    Form1.Constraints.MinWidth:=Form1.Width;
    Form1.Constraints.MaxWidth:=Form1.Width;
    Form1.Constraints.MinHeight:=Form1.Height;
    Form1.Constraints.MaxHeight:=Form1.Height;

    Timer1.Enabled:=true;
    TCheckThread.Create(false)
  end
end;





end.
